% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spca-package.R
\docType{package}
\name{spca-package}
\alias{spca-package}
\title{Utilities for computing Sparse Principal Components with the LS SPCA method.}
\description{
Sparse principal components have few loadings different from zero.  The
functions in this package compute the sparse components with the method LS
SPCA. These solutions attain the Least Squares approximation to the data
using a correlation (or covariance) matrix.\cr \cr The solutions are
obtained either through a Branch-and-Bound search (\code{\link{spcabb}}) or
a more efficient iterative backward Elimination Algorithm
(\code{\link{spcabe}}). \cr\cr If the indices of the sparse loadings are
known, the LS SPCA solutions can be computed with \code{\link{spca}}\cr\cr
The output is an object of class spca. The minimal spca object contains the
following elements: \tabular{ll}{ loadings\tab A matrix with the loadings
scaled to unit \eqn{L_2} norm in the columns.\cr vexp\tab A vector with the
\% variance explained by each component.\cr vexpv\tab A vector with the \%
variance explained by each principal component.\cr ind\tab A list of the indices
of the sparse loadings.} The following methods
are available \tabular{ll}{ \code{\link{print.spca}}\tab Prints the nonzero
loadings\cr \code{\link{plot.spca}}\tab Plots the variance explained and the
nonzero loadings\cr \code{\link{summary.spca}}\tab Prints summary statistics
of the solutions\cr \code{\link{showload}}\tab shows and plots the spca
loadings. Not implemented as an spca method.\cr \code{\link{compare.spca}}\tab
Compares different spca objects, giving summaries and plots. Not implemented
as an spca method. }
}
\references{
Giovanni M. Merola. 2014. \emph{Least Squares Sparse Principal
Component Analysis: a Backward Elimination approach to attain large
loadings.} To appear on Austr.&NZ Jou. Stats. Giovanni M. Merola.\cr\cr
Giovanni M. Merola. 2014. \emph{Sparse Principal Component Analysis: a
Least Squares approximation approach.}  \url{http://arxiv.org/abs/1406.1381}
}
\seealso{
\code{\link{spcabb}} and \code{\link{spcabe} for usage examples}.
}
\keyword{package}

