\name{simsurv}
\alias{simsurv}
\title{simsurv function}
\usage{
simsurv(X = cbind(age = runif(100, 5, 50), sex = rbinom(100, 1, 0.5), cancer =
  rbinom(100, 1, 0.2)), beta = c(0.0296, 0.0261, 0.035), omega = 1,
  dist = "exp", coords = matrix(runif(2 * nrow(X)), nrow(X), 2),
  cov.parameters = c(1, 0.1), cov.model = covmodel(model = "exponential",
  pars = NULL), mcmc.control = mcmcpars(nits = 1e+05, burn = 10000, thin =
  90), savechains = TRUE)
}
\arguments{
  \item{X}{a matrix of covariate information}

  \item{beta}{the parameter effects}

  \item{omega}{vector of parameters for the baseline hazard
  model}

  \item{dist}{the distribution choice: exp or weibull at
  present}

  \item{coords}{matrix with 2 columns giving the
  coordinates at which to simulate data}

  \item{cov.parameters}{a vector: the parameters for the
  covariance function}

  \item{cov.model}{an object of class covmodel, see
  ?covmodel}

  \item{mcmc.control}{mcmc control paramters, see
  ?mcmcpars}

  \item{savechains}{save all chains? runs faster if set to
  FALSE, but then you'll be unable to conduct
  convergence/mixing diagnostics}
}
\value{
in list element 'survtimes', a vector of simulated survival
times (the last simulated value from the MCMC chains) in
list element 'T' the MCMC chains
}
\description{
A function to simulate spatial parametric proportional
hazards model. The function works by simulating candidate
survival times using MCMC in parallel for each individual
based on each individual's covariates and the common
parameter effects, beta.
}
\seealso{
\link{covmodel}, \link{survspat}, \link{tpowHaz},
\link{exponentialHaz}, \link{gompertzHaz},
\link{makehamHaz}, \link{weibullHaz}
}

