% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gbi.R
\name{get_gbi}
\alias{get_gbi}
\title{Generate group by individual matrix}
\usage{
get_gbi(DT = NULL, group = "group", id = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{group}{Character string of group column (generated from one of
spatsoc's spatial grouping functions)}

\item{id}{Character string of ID column name}
}
\value{
\code{get_gbi} returns a group by individual matrix (columns
represent individuals and rows represent groups).

Note that \code{get_gbi} is identical in function for turning the outputs
of \code{spatsoc} into social networks as
\code{\link[asnipe:get_group_by_individual]{asnipe::get_group_by_individual}}
but is more efficient thanks to
\code{\link[data.table:dcast.data.table]{data.table::dcast}}.
}
\description{
\code{get_gbi} generates a group by individual matrix. The function accepts a
\code{data.table} with individual identifiers and a group column. The group
by individual matrix can then be used to build a network using
\code{\link[asnipe:get_network]{asnipe::get_network}}.
}
\details{
The \code{DT} must be a \code{data.table}. If your data is a
\code{data.frame}, you can convert it by reference using
\code{\link[data.table:setDT]{data.table::setDT}}.

The \code{group} argument expects the name of a column which corresponds to
an integer group identifier (generated by \code{\link{spatsoc}}'s grouping
functions).

The \code{id} argument expects the name of a column which corresponds to the
individual identifier.
}
\examples{
# Load data.table
library(data.table)

# Read example data
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))

# Cast the character column to POSIXct
DT[, datetime := as.POSIXct(datetime, tz = 'UTC')]
DT[, yr := year(datetime)]

# EPSG code for example data
utm <- 'EPSG:32736'

group_polys(DT, area = FALSE, hrType = 'mcp',
            hrParams = list(percent = 95),
            projection = utm, id = 'ID', coords = c('X', 'Y'),
            splitBy = 'yr')

gbiMtrx <- get_gbi(DT = DT, group = 'group', id = 'ID')

}
\seealso{
\code{\link{group_pts}} \code{\link{group_lines}}
\code{\link{group_polys}}

Other Social network tools: 
\code{\link{randomizations}()}
}
\concept{Social network tools}
