% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_correlation.R
\name{pair_correlation}
\alias{pair_correlation}
\title{Univariate Pair Correlation Function}
\usage{
pair_correlation(
  mif,
  mnames,
  r_range = NULL,
  num_permutations = 100,
  edge_correction = "translation",
  keep_permutation_distribution = FALSE,
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL,
  ...
)
}
\arguments{
\item{mif}{object of class `mif`}

\item{mnames}{character vector of marker names}

\item{r_range}{numeric vector including 0. If ignored, `spatstat` will decide range}

\item{num_permutations}{integer indicating how many permutations to run to determine CSR estimate}

\item{edge_correction}{character string of edge correction to apply to Ripley's K estimation}

\item{keep_permutation_distribution}{boolean for whether to keep the permutations or not}

\item{workers}{integer for number of threads to use when calculating metrics}

\item{overwrite}{boolean whether to overwrite existing results in the univariate_pair_correlation slot}

\item{xloc}{column name of single x value}

\item{yloc}{column name of single y value}

\item{...}{other parameters to provide `spatstat::pcf` 

The Pair Correlation Function uses the derivative of Ripley's K so it does take slightly longer to calculate

`xloc` and `yloc`, if NULL, will be calculated from columns `XMax`, `XMin`, `YMax`, and `YMin`.}
}
\value{
mif object with with the univariate_pair_correlation derived slot filled or appended to
}
\description{
Implementation of the univariate pair correlation function from spatstat
}
