% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tuning.R
\name{plot_tuning}
\alias{plot_tuning}
\title{Plots a tuning object produced by \code{\link[=rf_tuning]{rf_tuning()}}}
\usage{
plot_tuning(
  model,
  point.color = viridis::viridis(
    100,
    option = "F"
  ),
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf_tuning]{rf_tuning()}}. Default: \code{NULL}}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F")}}

\item{verbose}{Logical, if \code{TRUE}, the plot is printed. Default: \code{TRUE}}
}
\value{
A ggplot.
}
\description{
Plots the tuning of the hyperparameters \code{num.trees}, \code{mtry}, and \code{min.node.size} performed by \code{\link[=rf_tuning]{rf_tuning()}}.
}
\examples{
if(interactive()){

#load example data
data(plant_richness_df)

#fit random forest model
rf.model <- rf(
  data = plant_richness_df,
  dependent.variable.name = "richness_species_vascular",
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  distance.matrix = distance_matrix,
  distance.thresholds = 0,
  n.cores = 1,
  verbose = FALSE
)

#tune random forest model
rf.model <- rf_tuning(
 model = rf.model,
 xy = plant_richness_df[, c("x", "y")],
 n.cores = 1,
 verbose = FALSE
)

#generate tuning plot
plot_tuning(model = rf.model)

}
}
\seealso{
\code{\link[=rf_tuning]{rf_tuning()}}
}
