% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.invert.R
\name{raster.invert}
\alias{raster.invert}
\title{Invert raster}
\usage{
raster.invert(x)
}
\arguments{
\item{x}{raster object}
}
\value{
raster class object with inverted (flipped) raster values
}
\description{
Inverts (flip) the values of a raster
}
\note{
Inverts raster values using the formula: (((x - max(x)) * -1) + min(x)
}
\examples{
\dontrun{
  library(raster)
  r <- raster(nrows=500, ncols=500, xmn=571823, xmx=616763, 
              ymn=4423540, ymx=4453690)
    r[] <- runif(ncell(r), 1, 100)
 r <- focal(r, focalWeight(r, 150, "Gauss") )
  r.inv <- raster.invert(r)
    par(mfrow=c(1,2))
      plot(r, main="original raster")
      plot(r.inv, main="inverted raster") 
}     

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
