% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpi.R
\name{tpi}
\alias{tpi}
\title{Topographic Position Index (tpi)}
\usage{
tpi(x, scale = 3, win = "rectangle", normalize = FALSE)
}
\arguments{
\item{x}{A raster class object}

\item{scale}{The focal window size}

\item{win}{Window type. Options are "rectangle" and "circle"}

\item{normalize}{Apply deviation correction that normalizes to local surface roughness}
}
\value{
raster class object of tpi
}
\description{
Calculates topographic position using mean deviations
}
\examples{
 library(raster)
 data(elev)

# calculate tpi and plot 
  tpi9 <- tpi(elev, scale=9)     
    par(mfrow=c(1,2))
      plot(elev, main="original raster")
      plot(tpi9, main="tpi 9x9")

}
\references{
De Reu, J., J. Bourgeois, M. Bats, A. Zwertvaegher, V. Gelorini, et al., (2014) Application of the topographic position index to heterogeneous landscapes. Geomorphology, 186:39-49.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
