% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abfir.R
\name{abfir}
\alias{abfir}
\alias{abfir-spatPomp}
\alias{abfir,spatPomp-method}
\alias{abfir-abfird_spatPomp}
\alias{abfir,abfird_spatPomp-method}
\title{Adapted Bagged Filter with Intermediate Resampling (ABF-IR)}
\usage{
\S4method{abfir}{spatPomp}(
  object,
  Np,
  Nrep,
  nbhd,
  Ninter,
  tol = (1e-300),
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{abfir}{abfird_spatPomp}(object, Np, Nrep, nbhd, Ninter, tol, ...)
}
\arguments{
\item{object}{A \code{spatPomp} object.}

\item{Np}{The number of particles used within each replicate for the adapted simulations.}

\item{Nrep}{The number of bootstrap replicates for the adapted simulations.}

\item{nbhd}{A neighborhood function with three arguments: \code{object}, \code{time} and \code{unit}.
The function should return a \code{list} of two-element vectors that represent space-time neighbors of \eqn{(u,n)},
which is represented by \code{c(unit,time)}. See example below for more details.}

\item{Ninter}{the number of intermediate resampling time points. By default, this is set equal to the number of units.}

\item{tol}{If the resampling weight for a particle is zero due to floating-point precision issues, it is set to the value of \code{tol} since resampling has to be done.}

\item{...}{If a \code{params} argument is specified, \code{abf} will estimate the likelihood at that parameter set instead of at \code{coef(object)}.}

\item{verbose}{logical; if \code{TRUE}, messages updating the user on progress will be printed to the console.}
}
\value{
Upon successful completion, \code{abfir()} returns an object of class
\sQuote{abfird_spatPomp} containing the algorithmic parameters used to run \code{abfir()}
and the estimated likelihood.
}
\description{
An algorithm for estimating the filter distribution and likelihood of a spatiotemporal partially-observed Markov process model.
Running \code{abfir} causes the algorithm to run Monte Carlo replicated jobs which
each carry out an adapted simulation using intermediate resampling.
Adapted simulation is an easier task than filtering, since particles in each replicate
remain close to each other. Intermediate resampling further assists against
the curse of dimensionality (COD) problem for importance sampling.
The adapted simulations are then weighted in a way that mitigates COD by
making a weak coupling assumption to get an approximate filter distribution.
As a by-product, we also get an approximation to the likelihood of the data.
}
\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{logLik}}}{ yields a biased estimate of the log-likelihood of
the data under the model. }
}
}

\examples{
# Complete examples are provided in the package tests
\dontrun{
# Create a simulation of a Brownian motion
b <- bm(U=2, N=5)

# Create a neighborhood function mapping a point in space-time
# to a list of ``neighboring points" in space-time
bm_nbhd <- function(object, time, unit) {
  nbhd_list = list()
  if(time > 1 && unit > 1){
    nbhd_list = c(nbhd_list, list(c(unit-1, time-1)))
  }
  return(nbhd_list)
}
# Run ABFIR with specified number of Monte Carlo replicates and particles
# per replicate
abfird_bm <- abfir(b,
                  Nrep = 2,
                  Np=10,
                  nbhd = bm_nbhd,
                  Ninter = length(unit_names(b)))
# Get the likelihood estimate from ABFIR
logLik(abfird_bm)
}
}
\references{
\ionides2021
}
\seealso{
likelihood maximization algorithms: \code{ienkf()}, \code{igirf()}, \code{iubf()}, \code{ibpf()}

Other likelihood evaluation algorithms: 
\code{\link{abf}()},
\code{\link{bpfilter}()},
\code{\link{enkf}()},
\code{\link{girf}()}
}
\author{
Kidus Asfaw
}
\concept{likelihood evaluation algorithms}
