% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimcov.r
\name{estimcov}
\alias{estimcov}
\title{Estimation of variance, intra-subject-correlation and dropout}
\source{
\code{estimcov} uses code contributed Roland Gerard Gera.
}
\usage{
estimcov(data, Time, Startvalues = c(3, 0.5, 1), stepwidth = c(0.001, 0.001,
  0.001), maxiter = 10000, lower = c(1e-04, 1e-04, 1e-04), upper = c(Inf,
  5, 3))
}
\arguments{
\item{data}{list of gathered data. The list must be consistent with the gernerated data of \code{\link{r.gee.1subgroup}}}

\item{Time}{list with observed time points: see 'Details'}

\item{Startvalues}{startvalues for the paramteres \code{var},\code{rho} and \code{theta}}

\item{stepwidth}{vector of stepwidths which the optimisation-function should use}

\item{maxiter}{value setting maximal amount of iterations for the optimisation algorithm}

\item{lower}{lower bound for \code{var},\code{rho} and \code{theta}}

\item{upper}{upper bound for \code{var},\code{rho} and \code{theta}}
}
\value{
\code{estimcov} returns a list with two vectors. The first entry consists of a vector with estimations for c(\code{var},\code{rho},\code{theta})
while the second entry contains a vector, describing the empirical dropout-chance per timepoint.
}
\description{
\code{estimcov} estimates variance, intra-subject-correlation and dropout given empirical data.
}
\details{
Function \code{estimcov} fits a covariance-matrix with parameters \code{var},\code{rho} and \code{theta} (see \code{\link{gen_cov_cor}} for matrix generation) to an empirical covarince-matrix provided by \code{data}.
}
\examples{
#Generate data from longitudinal-model
set.seed(2015)
dataset<-r.gee.1subgroup(n=300, reg=list(c(0,0,0,0.1),c(0,0,0,0.1)), sigma=c(3,2.5), tau=0.5, 
rho=0.25, theta=1, k=1.5, Time=c(0:5), OD=0.2)

estimate<-estimcov(data=dataset,Time=c(0:5))
estimate
}
\seealso{
\code{\link{r.gee.1subgroup}} for information on the generated longitudinal data and \code{\link{n.gee.1subgroup}} for the calculation of
initial sample sizes for longitudinal GEE-models and \code{\link{bssr.gee.1subgroup}} for blinded
sample size reestimation within a trial. See \code{\link{gen_cov_cor}} for more information on the generation of covariance matrices.
}

