% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cytometryDiscrete}
\alias{cytometryDiscrete}
\title{The discrete cytometry network}
\format{A \code{\link{list}} with three components:

\itemize{
\item \code{dag} An \code{\link[sparsebnUtils]{edgeList}} containing the consensus network (11 nodes, 17 edges).
\item \code{data} A \code{\link{data.frame}} with 11 variables and 5400 observations.
\item \code{ivn} A \code{\link{list}} specifying which nodes are under intervention in each observation.
Compatible with the input to \code{\link[sparsebnUtils]{sparsebnData}}.
}}
\usage{
data(cytometryDiscrete)
}
\description{
Data and network for analyzing the flow cytometry experiment
from \href{http://science.sciencemag.org/content/308/5721/523.long}{Sachs et al. (2005)}.
The data is a cleaned and discretized version of the raw data (see \code{\link{cytometryContinuous}}) from these experiments.
}
\examples{
# Create a valid sparsebnData object from the cytometry data
data(cytometryDiscrete)
dat <- sparsebnData(cytometryDiscrete$data, type = "d", ivn = cytometryDiscrete$ivn)

}
\keyword{datasets}

