% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri_constraint_constructor.R
\name{smooth.construct.symm.smooth.spec}
\alias{smooth.construct.symm.smooth.spec}
\title{Symmetric bivariate smooths constructor}
\usage{
\method{smooth.construct}{symm.smooth.spec}(object, data, knots)
}
\arguments{
\item{object}{is a smooth specification object or a smooth object.}

\item{data}{a data frame, model frame or list containing the values
of the (named) covariates at which the smooth term is to be evaluated.}

\item{knots}{an optional data frame supplying any knot locations
to be supplied for basis construction.}
}
\value{
An object of class "symm.smooth". See \code{\link[mgcv]{smooth.construct}} for the elements it will contain.
}
\description{
The \code{symm} class is a new smooth class that is appropriate for symmetric bivariate smooths, e.g. of covariance functions,
using tensor-product smooths in a \code{gam} formula. A symmetry constraint matrix is constructed
(see \code{\link[sparseFLMM]{make_summation_matrix}}) to impose
a symmetry constraint on the spline coefficients, which considerably reduces the number of coefficients that have to be estimated.
}
\details{
The underlying procedure is the following: First, the marginal spline design matrices and the corresponding
marginal difference penalties are built. Second, the tensor product of the marginal design matrices is built
and the bivariate penalty matrix is set up. Third, the constraint matrix is applied
to the tensor product design matrix and to the penalty matrix.
}
\references{
Cederbaum, Scheipl, Greven (2016): Fast symmetric additive covariance smoothing.
Submitted on arXiv.
}
\seealso{
\code{\link[mgcv]{smooth.construct}} and \code{\link[mgcv]{smoothCon}} for details on constructors
}

