% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fft.R
\name{fft2d}
\alias{fft2d}
\title{2D fast-Fourier wrapper around 'fftwtools' or 'stats' package}
\usage{
fft2d(x, inverse = FALSE, fftw = sparr:::fftw_available())
}
\arguments{
\item{x}{A numeric matrix to be transformed.}

\item{inverse}{Whether it should compute the inverse transform (defaults to \code{FALSE}).}

\item{fftw}{Whether the \code{fftwtools} R package is available.}
}
\value{
The fast-Fourier (inverse) transform. A complex-valued matrix of the same size as \code{x}.
}
\description{
Utilises the Fastest Fourier Transform in the West (FFTW) via the 'fftwtools'
package if available, else reverts to built-in functionality
}
\details{
This function is called wherever \code{sparr} seeks to perform a 2D fast-Fourier
transform. Where available, computational expense is noticeably reduced by appealing to routines 
in the independent `FFTW' toolbox. The user is encouraged to install the corresponding R package \code{fftwtools} from CRAN;
this function will automatically detect and use the faster option, otherwise will 
defer to the built-in \code{\link[stats]{fft}}.
}
\examples{
\dontrun{

# System check
sparr:::fftw_available()

system.time(fft(matrix(1:2000^2,2000)))
system.time(fft2d(matrix(1:2000^2,2000)))
}

}
\author{
J.C. Marshall
}
