% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/livy_connection.R
\name{livy_config}
\alias{livy_config}
\title{Create a Spark Configuration for Livy}
\usage{
livy_config(
  config = spark_config(),
  username = NULL,
  password = NULL,
  negotiate = FALSE,
  custom_headers = list(`X-Requested-By` = "sparklyr"),
  ...
)
}
\arguments{
\item{config}{Optional base configuration}

\item{username}{The username to use in the Authorization header}

\item{password}{The password to use in the Authorization header}

\item{negotiate}{Whether to use gssnegotiate method or not}

\item{custom_headers}{List of custom headers to append to http requests. Defaults to \code{list("X-Requested-By" = "sparklyr")}.}

\item{...}{additional Livy session parameters}
}
\value{
Named list with configuration data
}
\description{
Create a Spark Configuration for Livy
}
\details{
Extends a Spark \code{spark_config()} configuration with settings
for Livy. For instance, \code{username} and \code{password}
define the basic authentication settings for a Livy session.

The default value of \code{"custom_headers"} is set to \code{list("X-Requested-By" = "sparklyr")}
in order to facilitate connection to Livy servers with CSRF protection enabled.

Additional parameters for Livy sessions are:
\describe{
  \item{\code{proxy_user}}{User to impersonate when starting the session}
  \item{\code{jars}}{jars to be used in this session}
  \item{\code{py_files}}{Python files to be used in this session}
  \item{\code{files}}{files to be used in this session}
  \item{\code{driver_memory}}{Amount of memory to use for the driver process}
  \item{\code{driver_cores}}{Number of cores to use for the driver process}
  \item{\code{executor_memory}}{Amount of memory to use per executor process}
  \item{\code{executor_cores}}{Number of cores to use for each executor}
  \item{\code{num_executors}}{Number of executors to launch for this session}
  \item{\code{archives}}{Archives to be used in this session}
  \item{\code{queue}}{The name of the YARN queue to which submitted}
  \item{\code{name}}{The name of this session}
  \item{\code{heartbeat_timeout}}{Timeout in seconds to which session be orphaned}
}

Note that \code{queue} is supported only by version 0.4.0 of Livy or newer.
If you are using the older one, specify queue via \code{config} (e.g.
\code{config = spark_config(spark.yarn.queue = "my_queue")}).
}
