% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_interaction.R
\name{ft_interaction}
\alias{ft_interaction}
\title{Feature Transformation -- Interaction (Transformer)}
\usage{
ft_interaction(x, input_cols, output_col, uid = random_string("interaction_"),
  ...)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_cols}{The names of the input columns}

\item{output_col}{The name of the output column.}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}
}
\value{
The object returned depends on the class of \code{x}.

\itemize{
  \item \code{spark_connection}: When \code{x} is a \code{spark_connection}, the function returns a \code{ml_transformer},
  a \code{ml_estimator}, or one of their subclasses. The object contains a pointer to
  a Spark \code{Transformer} or \code{Estimator} object and can be used to compose
  \code{Pipeline} objects.

  \item \code{ml_pipeline}: When \code{x} is a \code{ml_pipeline}, the function returns a \code{ml_pipeline} with
  the transformer or estimator appended to the pipeline.

  \item \code{tbl_spark}: When \code{x} is a \code{tbl_spark}, a transformer is constructed then
  immediately applied to the input \code{tbl_spark}, returning a \code{tbl_spark}
}
}
\description{
Implements the feature interaction transform. This transformer takes in Double and
  Vector type columns and outputs a flattened vector of their feature interactions.
  To handle interaction, we first one-hot encode any nominal features. Then, a
  vector of the feature cross-products is produced.
}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-features.html} for
  more information on the set of transformations available for DataFrame
  columns in Spark.

Other feature transformers: \code{\link{ft_binarizer}},
  \code{\link{ft_bucketizer}},
  \code{\link{ft_chisq_selector}},
  \code{\link{ft_count_vectorizer}}, \code{\link{ft_dct}},
  \code{\link{ft_elementwise_product}},
  \code{\link{ft_hashing_tf}}, \code{\link{ft_idf}},
  \code{\link{ft_imputer}},
  \code{\link{ft_index_to_string}}, \code{\link{ft_lsh}},
  \code{\link{ft_max_abs_scaler}},
  \code{\link{ft_min_max_scaler}}, \code{\link{ft_ngram}},
  \code{\link{ft_normalizer}},
  \code{\link{ft_one_hot_encoder}}, \code{\link{ft_pca}},
  \code{\link{ft_polynomial_expansion}},
  \code{\link{ft_quantile_discretizer}},
  \code{\link{ft_r_formula}},
  \code{\link{ft_regex_tokenizer}},
  \code{\link{ft_sql_transformer}},
  \code{\link{ft_standard_scaler}},
  \code{\link{ft_stop_words_remover}},
  \code{\link{ft_string_indexer}},
  \code{\link{ft_tokenizer}},
  \code{\link{ft_vector_assembler}},
  \code{\link{ft_vector_indexer}},
  \code{\link{ft_vector_slicer}}, \code{\link{ft_word2vec}}
}
