% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarizers}
\alias{summarizers}
\title{Wrapper functions for commonly used summarizer functions}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{window}{Either a R expression specifying time windows to be summarized
(e.g., `in_past("1h")` to summarize data from looking behind 1 hour at
each time point, `in_future("5s")` to summarize data from looking forward
5 seconds at each time point), or `NULL` to compute aggregate statistics
on rows grouped by timestamps}

\item{column}{Column to be summarized}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each row with the time series it belongs to (i.e., any
2 rows having equal values in those columns will be associated with the
same time series, and any 2 rows having differing values in those columns
are considered to be from 2 separate time series and will therefore be
summarized separately)
By default, `key_colums` is empty and all rows are considered to be part of
a single time series.}
}
\description{
R wrapper functions for commonly used Flint summarizer functionalities such as
sum and count.
}
