% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_wrappers.R
\name{IRF}
\alias{IRF}
\title{Estimate impulse response functions}
\usage{
IRF(
  model,
  horizon = 10,
  CI = c(0.1, 0.9),
  bootstrap.type = "auto",
  bootstrap.num = 100,
  bootstrap.parallel = FALSE,
  bootstrap.cores = -1
)
}
\arguments{
\item{model}{VAR, RVAR, LP, or RLP class object}

\item{horizon}{int: number of periods}

\item{CI}{numeric vector: c(lower ci bound, upper ci bound)}

\item{bootstrap.type}{string: bootstrapping technique to use ('auto', 'standard', or 'wild'); if auto then wild is used for IV or IV-short, else standard is used}

\item{bootstrap.num}{int: number of bootstraps}

\item{bootstrap.parallel}{boolean: create IRF draws in parallel}

\item{bootstrap.cores}{int: number of cores to use in parallel processing; -1 detects and uses half the available cores}
}
\value{
data frame with columns \code{target}, \code{shock}, \code{horizon}, \code{response.lower}, \code{response}, \code{response.upper}; regime-based models return a list with a data frame per regime.
}
\description{
See VAR, RVAR, LP, and RLP documentation for details
regarding models and structural errors.
}
\examples{
\donttest{

 # simple time series
 AA = c(1:100) + rnorm(100)
 BB = c(1:100) + rnorm(100)
 CC = AA + BB + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, AA, BB, CC)

 # estimate VAR
  var =
    sovereign::VAR(
      data = Data,
      horizon = 10,
      freq = 'month',
      lag.ic = 'BIC',
      lag.max = 4
    )

 # impulse response function
 var.irf = sovereign::IRF(var)

  # local projection forecasts
  lp =
    sovereign::LP(
      data = Data,
      horizon = c(1:10),
      lag.ic = 'AIC',
      lag.max = 4,
      type =  'both',
      freq = 'month')

  # LP impulse response function
  lp.irf = sovereign::IRF(lp)

}

}
\seealso{
\code{\link[=var_irf]{var_irf()}}

\code{\link[=rvar_irf]{rvar_irf()}}

\code{\link[=lp_irf]{lp_irf()}}

\code{\link[=rlp_irf]{rlp_irf()}}
}
