% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_soundgen.R
\name{wiggleAnchors}
\alias{wiggleAnchors}
\title{Randomly modify anchors}
\usage{
wiggleAnchors(df, temperature, temp_coef, low, high, wiggleAllRows = FALSE)
}
\arguments{
\item{df}{dataframe of anchors, for ex. \code{data.frame(time = c(0, .1, .8,
1), value = c(100, 230, 180, 90))}}

\item{temperature, temp_coef}{regulate the amount of stochasticity
("wiggling"). Since \code{temperature} is used in several functions,
\code{temp_coef} gives more flexibility by controlling how much temperature
affects this particular aspect, namely random variation in anchors. These
two are multiplied, so \code{temp_coef} of 0.5 halves the effect of
temperature.}

\item{low, high}{bounds on possible variation. Both \code{low} and \code{high}
should be vectors of length 2: the first element specifies the boundary for
\code{df$time} and the second for \code{df$value}. Ex.: low = c(0,1) - low
bound on "time"=0, low bound on "value"=1}

\item{wiggleAllRows}{should the first and last time anchors be wiggled? (TRUE
for breathing, FALSE for other anchors)}
}
\value{
Modified original dataframe.
}
\description{
Internal soundgen function.
}
\details{
A helper function for introducing random variation into any anchors (for
pitch / breathing / amplitude / ...). At higher temperatures can also add or
delete an anchor. NB: make sure the lower and upper bounds are reasonable
given the scale of df$value!
}
\examples{
soundgen:::wiggleAnchors(df = data.frame(
  time = c(0, .1, .8, 1), value = c(100, 230, 180, 90)),
  temperature = .2, temp_coef = .1, low = c(0, 50), high = c(1, 1000),
  wiggleAllRows = FALSE) # pitch
soundgen:::wiggleAnchors(df = data.frame(time = 0, value = 240),
  temperature = .2, temp_coef = .1, low = c(0, 50), high = c(1, 1000),
  wiggleAllRows = FALSE) # pitch, sinle anchor
soundgen:::wiggleAnchors(df = data.frame(
  time = c(-100, 100, 600, 900), value = c(-120, -80, 0, -120)),
  temperature = .4, temp_coef = .5, low = c(-Inf, -120), high = c(+Inf, 30),
  wiggleAllRows = TRUE) # noise
# formants
formants = list(f1 = list(time = 0, freq = 860, amp = 30, width = 120),
                f2 = list(time = c(0,1), freq = 1280,
                amp = c(10,40), width = 120))
for (f in 1:length(formants)) {
  formants[[f]] = soundgen:::wiggleAnchors(
    df = formants[[f]],
    temperature = .4, temp_coef = .5,
    low = c(0, 50, 0, 1),
    high = c(1, 8000, 120, 2000),
    wiggleAllRows = FALSE
  )
}
print(formants)
}
\keyword{internal}
