% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{list.transpose}
\alias{list.transpose}
\title{Transpose a nested list.}
\usage{
list.transpose(x)
}
\arguments{
\item{x}{[list] The list to be transposed.}
}
\value{
[list] The transposed list.
}
\description{
Taken from https://rdrr.io/cran/stackoverflow/src/R/tlist.R. I prefer to copy a short bit of code than to add a dependency.
}
\details{
R's \code{\link{t}} function does not have a method for lists. This pretty little piece of code is effectively that. Say you have a list with three sublists, each containg a vector of ten elements. The three sublists are languages, and the ten elements are words in those languages. Functions from the \code{\link{apply}} family only let you loop through languages and with each iteration you have access to all the words from the given language, but only from that language. \code{list.transpose} turns such a list into a list of ten sublists, each containing a vector with three elements -- so you can loop through words, and have in each iteration access to word nr 1 from all three languages, then word nr 2, and so on.
}
\examples{
soundcorrs:::list.transpose (list (1:3, 4:6, 7:9))
}
\keyword{internal}
