% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_noise.R
\name{find_noise}
\alias{find_noise}
\title{Detect energy peaks in recordings with non-relevant events}
\usage{
find_noise(recording, nmax = 1, plot = FALSE)
}
\arguments{
\item{recording}{Object of class "rc".}

\item{nmax}{Integer indicating the maximum number of peaks to detect in
the recording.}

\item{plot}{Logical. If TRUE a plot showing the peak(s) is returned.}
}
\value{
A vector with the temporal position of the
identified peak(s), in samples.
}
\description{
Detects the temporal position of the desired number of
energy peaks in a recording exclusively with non-relevant events.
}
\examples{
# Create a sample wav file in a temporary directory
recording <- tuneR::noise(duration = 44100)
temp_dir <- tempdir()
rec_path <- file.path(temp_dir, "recording.wav")
tuneR::writeWave(recording, filename = rec_path)
# Import the sample wav file
new_rec <- import_audio(rec_path, butt = FALSE, tx = 1)
find_noise(new_rec, nmax = 1, plot = FALSE)
file.remove(rec_path)
}
\author{
Bruno Silva
}
