\name{OmOM_Observation-class}

\Rdversion{1.1}

\docType{class}

\alias{OmOM_Observation-class}
\alias{OmOM_ObservationOrNULL-class}
\alias{OmOM_Observation}

\alias{sosCoordinates,OmOM_Observation-method}
\alias{sosFeatureIds,OmOM_Observation-method}
\alias{sosFeaturesOfInterest,OmOM_Observation-method}
\alias{sosObservedProperties,OmOM_Observation-method}
\alias{sosProcedures,OmOM_Observation-method}
\alias{sosResult,OmOM_Observation-method}
\alias{sosTime,OmOM_Observation-method}

\title{Class \code{"OmOM_Observation"}}
\description{Classes and construction functions for objects from the OGC Observations and Measurements specification, version 2.0.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("OmOM_Observation", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{phenomenonTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time that the result applies to the feature-of-interest. This is the time usually required for geospatial analysis of the result. Note: The phenomenonTime has been renamed to samplingTime in the O&M specification version 2.0. However, in order to be consistent with version 1.0 in SOS4R, we decided to leave the slot as is and just changed the parsing/encoding.}
    \item{\code{procedure}:}{Object of class \code{"ANY"}: The description of a process used to generate the result. It must be suitable for the observed property.}
    \item{\code{observedProperty}:}{Object of class \code{"SwePhenomenonProperty"}: Identifies or describes the phenomenon for which the observation result provides an estimate of its value. It must be a property associated with the type of the feature of interest.}
    \item{\code{featureOfInterest}:}{Object of class \code{"GmlFeature"}: A feature of any type (ISO 19109, ISO 19101), which is a representation of the observation target, being the real-world object regarding which the observation is made.}
    \item{\code{result}:}{Object of class \code{"ANY"}: Contains the value generated by the procedure. The type of the observation result must be consistent with the observed property, and the scale or scope for the value must be consistent with the quantity or category type.}
    \item{\code{metadata}:}{Object of class \code{"ANY"}: Observation metadata.}
    \item{\code{resultTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time when the procedure associated with the observation act was applied. For some observations these are identical, in which case the resultTime may be omitted. However, there are important cases where they differ.}
    \item{\code{resultQuality}:}{Object of class \code{"ANY"}: Event specific quality of a result.}
    \item{\code{parameter}:}{Object of class \code{"ANY"}: A general event-specific parameter. This will typically be used to record environmental parameters, or event-specific sampling parameters that are not tightly bound to either the feature-of-interest or the procedure.}
  }
}
\section{Extends}{
Class \code{"\linkS4class{OmOM_ObservationOrNULL}"}, directly.
}
\section{Methods}{
  \describe{
    \item{sosCoordinates}{\code{signature(obj = "OmOM_Observation")}: Accessor to the spatial cooridinates of an observation.}
    \item{sosFeatureIds}{\code{signature(obj = "OmOM_Observation")}: Accessor to the feature identifiers.}
    \item{sosFeaturesOfInterest}{\code{signature(obj = "OmOM_Observation")}: Accessor to the feature objects.}
    \item{sosObservedProperties}{\code{signature(obj = "OmOM_Observation")}: Accessor to the observed properties in the observation.}
    \item{sosProcedures}{\code{signature(obj = "OmOM_Observation")}: Accessor to the procedures in the observation.}
    \item{sosResult}{\code{signature(obj = "OmOM_Observation")}: Extract the data from the observation as a \code{data.frame}.}
    \item{sosTime}{\code{signature(obj = "OmOM_Observation")}: Accessor to the time period of the observation.}
	 }
}
\examples{
showClass("OmOM_Observation")
}
\keyword{classes}
