\name{OmObservation-class}
\Rdversion{1.1}

\docType{class}

\alias{OmObservation}
\alias{OmObservation-class}
\alias{OmObservationOrNULL-class}
\alias{show,OmObservation-method}
\alias{print,OmObservation-method}
\alias{print,OmObservationProperty-method}
\alias{toString,OmObservation-method}
\alias{toString,OmObservationProperty-method}
\alias{OmObservationProperty-class}
\alias{show,OmObservationProperty-method}
\alias{OmObservationProperty}
\alias{sosProcedures,OmObservation-method}
\alias{names.OmObservation}

\alias{sosResult}
\alias{sosResult,list-method}
\alias{sosResult,OmObservationProperty-method}
\alias{sosResult,OmObservation-method}

\alias{as.data.frame.OmObservation}
\alias{sosCoordinates,OmObservation-method}
\alias{sosFeaturesOfInterest,OmObservation-method}
\alias{sosFeatureIds,OmObservation-method}
\alias{sosObservedProperties,OmObservation-method}

\alias{sosGetCRS,OmObservation-method}

\title{Classes for om:Observation Elements}

\description{Classes and construction functions for objects from the OGC Observations and Measurements specification.}

\section{Objects from the Class}{
Objects can be created by calls to the construction functions of the form \code{OmObservation(...)} and \code{OmObservationProperty(...)}.

The following classes are virtual, no objects may be created from them: \code{OmObservationOrNULL-class}.
}

\usage{
OmObservation(samplingTime, procedure, observedProperty, featureOfInterest, result, metadata = NA, resultTime = NULL, resultQuality = NA, parameter = NA)
OmObservationProperty(href = as.character(NA), obs = NULL)
}

\section{Slots}{
  \describe{
    \item{\code{samplingTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time that the result applies to the feature-of-interest. This is the time usually required for geospatial analysis of the result.}
    \item{\code{procedure}:}{Object of class \code{"ANY"}: The description of a process used to generate the result. It must be suitable for the observed property.}
    \item{\code{observedProperty}:}{Object of class \code{"SwePhenomenonProperty"}: Identifies or describes the phenomenon for which the observation result provides an estimate of its value. It must be a property associated with the type of the feature of interest.}
    \item{\code{featureOfInterest}:}{Object of class \code{"GmlFeature"}: A feature of any type (ISO 19109, ISO 19101), which is a representation of the observation target, being the real-world object regarding which the observation is made.}
    \item{\code{result}:}{Object of class \code{"ANY"}: Contains the value generated by the procedure. The type of the observation result must be consistent with the observed property, and the scale or scope for the value must be consistent with the quantity or category type.}
    \item{\code{metadata}:}{Object of class \code{"ANY"}: Observation metadata.}
    \item{\code{resultTime}:}{Object of class \code{"GmlTimeObjectOrNULL"}: The time when the procedure associated with the observation act was applied. For some observations these are identical, in which case the resultTime may be omitted. However, there are important cases where they differ.}
    \item{\code{resultQuality}:}{Object of class \code{"ANY"}: Event specific quality of a result.}
    \item{\code{parameter}:}{Object of class \code{"ANY"}: A general event-specific parameter. This will typically be used to record environmental parameters, or event-specific sampling parameters that are not tightly bound to either the feature-of-interest or the procedure.}
    \item{\code{href}:}{Object of class \code{"character"}: Referenced observation in a \code{OmObservationProperty}.}
  }
}

\section{Extends}{
\bold{OmObservation}
Class \code{"\linkS4class{OmObservationOrNULL}"}, directly.
}

\section{Methods}{
  \describe{
    \item{sosResult}{\code{signature(obj = "OmObservation")}: Accessor function for the result slot of an observation or measurement.}
	 }
}

\arguments{
  \item{samplingTime}{See slot description.}
  \item{procedure}{See slot description.}
  \item{observedProperty}{See slot description.}
  \item{featureOfInterest}{See slot description.}
  \item{result}{See slot description.}
  \item{metadata}{See slot description.}
  \item{resultTime}{See slot description.}
  \item{resultQuality}{See slot description.}
  \item{parameter}{See slot description.}
  \item{href}{See slot description.}
  \item{obs}{See slot description.}
}

\details{
The class \code{OmObservationProperty} can be used to reference to an (online) observation.

The \verb{...OrNULL} classes are used to model optional slots.
}

\value{The construction functions return an object of the respective class.}

\references{Cox, S. (Ed.), Observations and Measurements – Part 1 - Observation schema, Open Geospatial Consortium Inc., OGC 07-022r1, Version: 1.0}

\author{Daniel Nüst \email{daniel.nuest@uni-muenster.de}}

%\note{  }
%\section{Warning }{}

\seealso{See Also as \code{\link{OmMeasurement-class}}.}

\examples{
showClass("OmObservation")
showClass("OmObservationProperty")
showClass("OmObservationOrNULL")

# TBD examples for construction methods
OmObservationProperty(href = "http://link.to/myObservation")

# get result from an observation
\dontrun{
result <- observation@result

# the accessor method also works with lists of observations
result <- sosResult(observation)
resultList <- sosResult(observationList)
}

}

\keyword{classes}
