% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnet.R
\name{cnet}
\alias{cnet}
\title{Complex network analysis}
\usage{
cnet(x, n, thres)
}
\arguments{
\item{x}{regs object.}

\item{n}{number of regions.}

\item{thres}{the cross-correlation threshold of the network.}
}
\description{
\code{cnet} plots the canonical network map of a single classification scheme.
}
\details{
The \code{cnet} function estimates the cross-correlation matrix of the average time series of
each region and plots a map linking the regions with cross-correlations above the selected threshold.
}
\examples{
dummy <- owda[Time <= 1600] #toy example
inp_som <- sominp(dummy)
my_som <- somspa(inp_som, rlen = 100, grid = somgrid(3, 3, "hexagonal"))
my_regions <- somregs(my_som, nregions = 6) 
cnet(my_regions, n = 5, thres = 0.2)
\donttest{
inp_som <- sominp(owda)
my_som <- somspa(inp_som, rlen = 1000, grid = somgrid(6, 6, "hexagonal"))
my_regions <- somregs(my_som, nregions = 15) 
cnet(my_regions, n = 12, thres = 0.3)}
}
