% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchVegdata.R,
%   R/get_vegplot_data_from_NASIS_db.R
\name{fetchVegdata}
\alias{fetchVegdata}
\alias{get_vegplot_from_NASIS_db}
\alias{get_vegplot_location_from_NASIS_db}
\alias{get_vegplot_species_from_NASIS_db}
\alias{get_vegplot_textnote_from_NASIS_db}
\alias{get_vegplot_transect_from_NASIS_db}
\alias{get_vegplot_transpecies_from_NASIS_db}
\alias{get_vegplot_tree_si_details_from_NASIS_db}
\alias{get_vegplot_tree_si_summary_from_NASIS_db}
\alias{get_vegplot_trhi_from_NASIS_db}
\alias{get_vegplot_transpoints_from_NASIS_db}
\alias{get_vegplot_prodquadrats_from_NASIS_db}
\alias{get_vegplot_speciesbasalarea_from_NASIS}
\title{Get vegetation plot data from local NASIS database}
\usage{
fetchVegdata(SS = TRUE, stringsAsFactors = NULL, dsn = NULL)

get_vegplot_from_NASIS_db(SS = TRUE, stringsAsFactors = NULL, dsn = NULL)

get_vegplot_location_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_trhi_from_NASIS_db(SS = TRUE, stringsAsFactors = NULL, dsn = NULL)

get_vegplot_species_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_transect_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_transpecies_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_transpoints_from_NASIS_db(SS = TRUE, dsn = NULL)

get_vegplot_prodquadrats_from_NASIS_db(SS = TRUE, dsn = NULL)

get_vegplot_tree_si_summary_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_speciesbasalarea_from_NASIS(SS = TRUE, dsn = NULL)

get_vegplot_tree_si_details_from_NASIS_db(
  SS = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)

get_vegplot_textnote_from_NASIS_db(
  SS = TRUE,
  fixLineEndings = TRUE,
  stringsAsFactors = NULL,
  dsn = NULL
)
}
\arguments{
\item{SS}{fetch data from the currently loaded selected set in NASIS or from the entire local database (default: \code{TRUE})}

\item{stringsAsFactors}{deprecated}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}

\item{fixLineEndings}{Replace \code{'\\r\\n'} with \code{'\\n'}; Default: \code{TRUE}}
}
\value{
A named list containing: "vegplot", "vegplotlocation", "vegplotrhi", "vegplotspecies", "vegtransect", "vegtransplantsum", 'vegsiteindexsum', "vegsiteindexdet", and  "vegplottext" tables
}
\description{
Get vegetation plot data from local NASIS database
}
