% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncode.R
\name{NASISChoiceList}
\alias{NASISChoiceList}
\title{Work with NASIS Choice Lists}
\usage{
NASISChoiceList(
  x,
  colnames = names(x),
  what = "ColumnPhysicalName",
  choice = c("ChoiceName", "ChoiceValue", "ChoiceLabel"),
  obsolete = FALSE,
  factor = TRUE,
  droplevels = FALSE,
  ordered = TRUE,
  simplify = TRUE,
  dsn = NULL
)
}
\arguments{
\item{x}{A named list of vectors to use as input for NASIS Choice List lookup}

\item{colnames}{vector of values of the column specified by \code{what}. E.g. \code{colnames="texcl"} for \code{what="ColumnPhysicalName"}. Default: \code{names(x)} (if x is named)}

\item{what}{passed to \code{get_NASIS_column_metadata()}; Column to match \code{x} against. Default \code{"ColumnPhysicalName"}; alternate options include \code{"DomainID"}, \code{"DomainName"}, \code{"DomainRanked"}, \code{"DisplayLabel"}, \code{"ChoiceSequence"}, \code{"ChoiceValue"}, \code{"ChoiceName"}, \code{"ChoiceLabel"}, \code{"ChoiceObsolete"}, \code{"ChoiceDescription"}, \code{"ColumnLogicalName"}}

\item{choice}{one of: \code{"ChoiceName"}, \code{"ChoiceValue"}, or \code{"ChoiceLabel"}}

\item{obsolete}{Include "obsolete" choices? Default: \code{FALSE}}

\item{factor}{Convert result to factor? Default: \code{TRUE}}

\item{droplevels}{Drop unused factor levels? Default: \code{TRUE} (used only when \code{factor=TRUE})}

\item{ordered}{Should the result be an ordered factor? Default: \code{TRUE} (use \emph{only} if \code{DomainRanked} is true for all choices)}

\item{simplify}{Should list result with length 1 be reduced to a single vector? Default: \code{TRUE}}

\item{dsn}{Optional: path to local SQLite database containing NASIS table structure; default: NULL}
}
\value{
A list of "choices" based on the input \code{x} that have been converted to a consistent target set of levels (specified by \code{choice}) via NASIS 7 metadata.

When \code{factor=TRUE} the result is a factor, possibly ordered when \code{ordered=TRUE} and the target domain is a "ranked" domain (i.e. \code{ChoiceSequence} has logical meaning).

When \code{factor=FALSE} the result is a character or numeric vector. Numeric vectors are always returned when \code{choice} is \code{"ChoiceValue"}.
}
\description{
Create (ordered) factors and interchange between choice names, values and labels for lists of input vectors.
}
\examples{

NASISChoiceList(1:3, "texcl")

NASISChoiceList(1:3, "pondfreqcl")

NASISChoiceList("Clay loam", "texcl", choice = "ChoiceValue")

NASISChoiceList("Silty clay loam", "texcl", choice = "ChoiceName")
}
