% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher_pearson.R
\name{FPearson}
\alias{FPearson}
\alias{dFPearson}
\alias{pFPearson}
\alias{qFPearson}
\alias{rFPearson}
\title{Fisher's transformation of the Pearson product moment correlation
coefficient}
\usage{
dFPearson(x, N, rho = 0, log = FALSE)

pFPearson(q, N, rho = 0, lower.tail = TRUE, log.p = FALSE)

qFPearson(p, N, rho = 0, lower.tail = TRUE, log.p = FALSE)

rFPearson(n, N, rho = 0, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{Numeric vectors of quantiles.}

\item{N}{Numeric vector.  Number of observations, (N > 3).}

\item{rho}{Numeric vector.  Population correlations, (-1 < rho < 1).}

\item{log, log.p}{A logical scalar; if TRUE, probabilities p are given as
log(p).}

\item{lower.tail}{A logical scalar.  If TRUE (default), probabilities
are P[X <= x], otherwise, P[X > x].}

\item{p}{A numeric vector of probabilities in [0,1].}

\item{n}{Numeric scalar.  The number of observations to be simulated.
If \code{length(n) > 1} then \code{length(n)} is taken to be the number
required.}
}
\description{
Density, distribution function, quantile function and random generator
for the distribution of Fisher's transformation of Pearson's product
moment correlation, based on a random sample from a bivariate normal
distribution
}
\examples{
dFPearson(-1:1, N = 10)
dFPearson(0, N = 11:20)

pFPearson(0.5, N = 10)
pFPearson(0.5, N = 10, rho = c(0, 0.3))

qFPearson((1:9)/10, N = 10, rho = 0.2)
qFPearson(0.5, N = c(10, 20), rho = c(0, 0.3))

rFPearson(6, N = 10, rho = 0.6)
}
\references{
Fisher, R. A. (1915). Frequency distribution of the values of
  the correlation coefficient in samples of an indefinitely large
  population. \emph{Biometrika}, \strong{10}(4), 507-521.
  \url{http://dx.doi.org/10.2307/2331838}

Fisher, R. A. (1921). On the "probable error" of a coefficient
  of correlation deduced from a small sample. \emph{Metron}, \strong{1},
  3-32.
  \url{https://digital.library.adelaide.edu.au/dspace/bitstream/2440/15169/1/14.pdf}
}
\seealso{
\code{\link[SuppDists]{Pearson}} in the SuppDists package for
  dpqr functions for the untransformed Pearson produce moment correlation
  coefficient.

\code{\link{correlation}}: correlation sampling distribution movie.
}
