% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothers.R
\name{bw.rot}
\alias{bw.rot}
\title{Silverman's rule-of-thumb bandwidth}
\usage{
bw.rot(
  x,
  kernel = c("gaussian", "uniform", "triangular", "epanechnikov", "quartic"),
  na.rm = FALSE,
  robust = TRUE,
  discontinuous = FALSE
)
}
\arguments{
\item{x}{A numeric vector without non-finite values.}

\item{kernel}{A string character: \code{"gaussian"}, \code{"uniform"},
\code{"triangular"}, \code{"epanechnikov"}, or  \code{"quartic"}.}

\item{na.rm}{Logical: should missing values be removed? Setting it to TRUE
may cause issues because variable-wise removal of NAs may return a
bandwidth that is inappropriate for the final data set for which it is
suggested.}

\item{robust}{Logical: safeguard against extreme observations? If TRUE, uses
\code{min(sd(x), IQR(x)/1.34)} to estimate the spread.}

\item{discontinuous}{Logical: if the true density is discontinuous (i.e. has
jumps), then, the formula for the optimal bandwidth for density estimation changes.}
}
\value{
A numeric vector of bandwidths that are a reasonable start optimal non-parametric density estimation of \code{x}.
}
\description{
A fail-safe function that would return a nice Silverman-like bandwidth
  suggestion for data for which the standard deviation might be NA or 0.
}
\details{
\eqn{\Sigma = \mathrm{\mathop{diag}}(\sigma^2_k)}{\Sigma = diag(\sigma^2_k)}
with
\eqn{\det\Sigma = \prod_k \sigma^2_k}{det \Sigma = prod(\sigma^2_k)}
and
\eqn{\Sigma^{-1} = \mathrm{\mathop{diag}}(1/\sigma^{2}_k)}{\Sigma = diag(1/\sigma^2_k)}).
Then, the formula 4.12 in Silverman (1986) depends only on \eqn{\alpha}{\alpha}, \eqn{\beta}{\beta}.
\eqn{\alpha = \mathrm{\mathop{diag}}(\sigma^2_k)}{\Sigma = diag(\sigma^2_k)}
(which depend only on the kernel and are fixed for a multivariate normal), and on the L2-norm of the
second derivative of the density. The (i, i)th element of the Hessian of multi-variate normal
(\eqn{\phi(x_1, \ldots, x_d) = \phi(X)}{\phi(x_1, ..., x_d) = \phi(X)}) is
\eqn{\phi(X)(x_i^2 - \sigma^2_i)/\sigma_i^4}{\phi(X)(x_i^2 - \sigma^2_i)/\sigma_i^4}.


The rule-of-thumb bandwidth is obtained under the assumption that the true
density is multivariate normal with zero covariances
(i.e. a diagonal variance-covariance matrix). For details,
see \insertCite{silverman1986density}{smoothemplik}.
}
\examples{
set.seed(1); bw.rot(stats::rnorm(100)) # Should be 0.3787568 in R version 4.0.4
set.seed(1); bw.rot(matrix(stats::rnorm(500), ncol = 10)) # 0.4737872 ... 0.7089850
}
\references{
\insertAllCited{}
}
