% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mof.zdt2.R
\name{makeZDT2Function}
\alias{makeZDT2Function}
\title{ZDT2 Function}
\usage{
makeZDT2Function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the two-objective ZDT2 test problem. The function is
nonconvex and resembles the ZDT1 function. For \eqn{m} objective it
is defined as follows
\deqn{f(\mathbf{x}) = \left(f_1(\mathbf{x}_1), f_2(\mathbf{x})\right)}
with
\deqn{f_1(\mathbf{x}_1) = \mathbf{x}_1, f_2(\mathbf{x}) = g(\mathbf{x}) h(f_1(\mathbf{x}_1), g(\mathbf{x}))}
where
\deqn{g(\mathbf{x}) = 1 + \frac{9}{m - 1} \sum_{i = 2}^m \mathbf{x}_i, h(f_1, g) = 1 - \left(\frac{f_1}{g}\right)^2}
and \eqn{\mathbf{x}_i \in [0,1], i = 1, \ldots, m}
}
\references{
E. Zitzler, K. Deb, and L. Thiele. Comparison of Multiobjective
Evolutionary Algorithms: Empirical Results. Evolutionary Computation, 8(2):173-195, 2000
}

