% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_smog.R
\name{plot.cv.smog}
\alias{plot.cv.smog}
\title{plot method for objects of \code{cv.smog} class}
\usage{
\method{plot}{cv.smog}(x, ...)
}
\arguments{
\item{x}{An fitted object in "cv.smog" class.}

\item{...}{Other graphical parameters to ggplot2.}
}
\description{
Yield a search path for optimal group penalty \eqn{G-\lambda} and \eqn{I-\lambda} using
the mean-squared errors from the cross-validations.
}
\details{
x-axis represents the group tuning parameter \eqn{\lambda_G} and y-axis for the interaction
tuning parameter \eqn{\lambda_I}, respectively. The point size demonstrates the maganitude
of MSE or negative log-likelihood.
}
\examples{

# generate design matrix x
set.seed(2018)
n=100;p=20
s=10
x=matrix(0,n,1+2*p)
x[,1]=sample(c(0,1),n,replace = TRUE)
x[,seq(2,1+2*p,2)]=matrix(rnorm(n*p),n,p)
x[,seq(3,1+2*p,2)]=x[,seq(2,1+2*p,2)]*x[,1]

g=c(p+1,rep(1:p,rep(2,p)))  # groups 
v=c(0,rep(1,2*p))           # penalization status
label=c("t",rep(c("prog","pred"),p))  # type of predictor variables

# generate beta
beta=c(rnorm(13,0,2),rep(0,ncol(x)-13))
beta[c(2,4,7,9)]=0

# generate y
data=x\%*\%beta
noise=rnorm(n)
snr=as.numeric(sqrt(var(data)/(s*var(noise))))
y=data+snr*noise

cvfit=cv.smog(x,y,g,v,label,type = "AIC", family="gaussian")
plot(cvfit)

}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\link{smog}, \link{cv.smog}, \link{cv.cglasso}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
