% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{single_tapmat1}
\alias{single_tapmat1}
\title{Tappered Matern covariance function (scalar - nu = 1/2)}
\usage{
single_tapmat1(d, sigsq, phi, theta)
}
\arguments{
\item{d}{a scalar representing the distance on which it is desired to
evaluate the covariance function.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,
controls the range of the spatial dependence.}

\item{theta}{\eqn{\theta} taper range.}
}
\value{
a scalar representing the (tappered matern) covariance between two
observations \code{d} apart of each other.
}
\description{
Computing the Matern covariance function for a single distance
measure, with \eqn{\nu = 1/2}.
}
\seealso{
\code{\link{single_matern}}, \code{\link{single_matern5}}
\code{\link{single_exp}}, \code{\link{mat_cov}}
}
\keyword{internal}
