% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precog.sim.R
\name{precog.sim}
\alias{precog.sim}
\title{Perform \code{precog.test} on simulated data.}
\usage{
precog.sim(
  nsim = 1,
  zones,
  ty,
  ex,
  w,
  pop,
  max_pop,
  logein,
  logeout,
  d,
  cl = NULL,
  tol_prob = 0.9,
  ysim = NULL
)
}
\arguments{
\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{zones}{A list with of candidate zones that includes
each regions and its adjacent neighbors.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{pop}{The population size associated with each
region.}

\item{max_pop}{The maximum population size allowable for
a cluster.}

\item{logein}{The \code{log} of the expected number of
cases in each candidate zone.}

\item{logeout}{The \code{log} of the expected number of
cases outside of each candidate zone.}

\item{d}{A precomputed distance matrix based on \code{coords}}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{tol_prob}{A single numeric value between 0 and 1
that describes the quantile of the tolerance envelopes
used to prefilter regions from the candidate zones.}

\item{ysim}{A matrix of size \code{nsim}\eqn{\times n},
where \eqn{n} is the number of regions in the study
area. This is a matrix of \code{nsim} realizations of
the case counts for each region in the study area under
the null hypothesis. This argument is only not meant to
be used by the user.}
}
\value{
A list with the vector of tolerance quantiles
  associated with each region and a vector with the
  maximum test statistic for each simulated data set.
}
\description{
\code{procog.sim} efficiently performs
\code{\link[smerc]{precog.test}} on a simulated data set.
The function is meant to be used internally by the
\code{\link[smerc]{precog.test}} function, but is
informative for better understanding the implementation
of the test.
}
\author{
Joshua French and Mohammad Meysami
}
