% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_ubpop.R
\name{optimal_ubpop}
\alias{optimal_ubpop}
\title{Optimal Population Upper Bound Statistics}
\usage{
optimal_ubpop(
  coords,
  cases,
  pop,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.05,
  ubpop_seq = seq(0.01, 0.5, len = 50),
  longlat = FALSE,
  cl = NULL,
  type = "poisson",
  min.cases = 0,
  simdist = "multinomial"
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop_seq}{A strictly increasing numeric vector with values between
min(pop)/sum(pop) and 1. The default is \code{seq(0.01, 0.5, len = 50)}.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}

\item{simdist}{Character string indicating the simulation
distribution. The default is \code{"multinomial"}, which
conditions on the total number of cases observed. The
other options are \code{"poisson"} and \code{"binomial"}}
}
\value{
Returns a \code{smerc_optimal_ubpop} object. This includes:
  \item{ubpop_seq}{The sequence of population bounds considered}
  \item{elbow_method}{An object with statistics related to the elbow method}
  \item{gini_method}{An object with statistics related to the gini method}
  \item{elbow_ubpop}{The population upperbound suggested by the elbow method}
  \item{gini_ubpop}{The population upperbound suggested by the Gini method}
}
\description{
\code{optimal_ubpop} computes statistics for choosing an optimal population
upper bound. \code{ubpop_seq} is a sequence of values to consider as the
optimal choice of upper bound. The smallest value must be at least
\code{min(pop)/sum(pop)} and should generally be less than or equal to 0.5.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
ubpop_stats <- optimal_ubpop(
  coords = coords, cases = nydf$cases,
  pop = nydf$pop, nsim = 49,
  ubpop_seq = seq(0.05, 0.5, by = 0.05)
)
ubpop_stats
\dontrun{
plot(ubpop_stats)
}
}
\references{
Meysami, Mohammad, French, Joshua P., and Lipner, Ettie M. The estimation of
the optimal cluster upper bound for scan methods in retrospective disease
surveillance. Submitted.

Han, J., Zhu, L., Kulldorff, M. et al. Using Gini coefficient to determining
optimal cluster reporting sizes for spatial scan statistics. Int J Health
Geogr 15, 27 (2016). <doi:10.1186/s12942-016-0056-6>
}
\seealso{
\code{\link{scan.test}}
}
\author{
Joshua French
}
