% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.test.R
\name{fast.test}
\alias{fast.test}
\title{Fast Subset Scan Test}
\usage{
fast.test(
  coords,
  cases,
  pop,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  ubpop = 0.5,
  longlat = FALSE,
  cl = NULL,
  type = "poisson"
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}
}
\value{
Returns a list of length two of class scan. The
  first element (clusters) is a list containing the
  significant, non-ovlappering clusters, and has the the
  following components: \item{locids}{The location ids of
  regions in a significant cluster.} \item{pop}{The total
  population in the cluser window.} \item{cases}{The
  observed number of cases in the cluster window.}
  \item{expected}{The expected number of cases in the
  cluster window.} \item{smr}{Standarized mortaility
  ratio (observed/expected) in the cluster window.}
  \item{rr}{Relative risk in the cluster window.}
  \item{loglikrat}{The loglikelihood ratio for the
  cluster window (i.e., the log of the test statistic).}
  \item{pvalue}{The pvalue of the test statistic
  associated with the cluster window.} The second element
  of the list is the centroid coordinates.  This is
  needed for plotting purposes.
}
\description{
\code{fast.test} performs the fast subset scan test of
Neill (2012).
}
\details{
The test is performed using the spatial scan test based
on the Poisson test statistic and a fixed number of
cases.  The windows are based on the Upper Level Sets
proposed by Patil and Taillie (2004).  The clusters
returned are non-overlapping, ordered from most
significant to least significant.  The first cluster is
the most likely to be a cluster.  If no significant
clusters are found, then the most likely cluster is
returned (along with a warning).
}
\examples{
data(nydf)
coords = with(nydf, cbind(longitude, latitude))
out = fast.test(coords = coords, cases = floor(nydf$cases),
               pop = nydf$pop,
               alpha = 0.05, longlat = TRUE,
               nsim = 49, ubpop = 0.5)
}
\references{
Neill, D. B. (2012), Fast subset scan for
  spatial pattern detection. Journal of the Royal
  Statistical Society: Series B (Statistical
  Methodology), 74: 337-360.
  <doi:10.1111/j.1467-9868.2011.01014.x>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
