% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smd.R
\name{smd}
\alias{smd}
\alias{smd,character,ANY,missing-method}
\alias{smd,character,ANY,numeric-method}
\alias{smd,logical,ANY,missing-method}
\alias{smd,logical,ANY,numeric-method}
\alias{smd,matrix,ANY,missing-method}
\alias{smd,matrix,ANY,numeric-method}
\alias{smd,list,ANY,missing-method}
\alias{smd,list,ANY,numeric-method}
\alias{smd,data.frame,ANY,missing-method}
\alias{smd,data.frame,ANY,numeric-method}
\title{Compute Standardized Mean Difference}
\usage{
smd(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{character,ANY,missing}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{character,ANY,numeric}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{logical,ANY,missing}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{logical,ANY,numeric}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{matrix,ANY,missing}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{matrix,ANY,numeric}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{list,ANY,missing}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{list,ANY,numeric}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{data.frame,ANY,missing}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)

\S4method{smd}{data.frame,ANY,numeric}(x, g, w, std.error = FALSE, na.rm = FALSE, gref = 1L, unwgt.var = TRUE)
}
\arguments{
\item{x}{a \code{vector} or \code{matrix} of values}

\item{g}{a vector of at least 2 groups to compare. This should coercable to a
\code{factor}.}

\item{w}{a vector of \code{numeric} weights (optional)}

\item{std.error}{Logical indicator for computing standard errors using
\code{\link{compute_smd_var}}. Defaults to \code{FALSE}.}

\item{na.rm}{Remove \code{NA} values from \code{x}? Defaults to \code{FALSE}.}

\item{gref}{an integer indicating which level of \code{g} to use as the reference
group. Defaults to \code{1}.}

\item{unwgt.var}{Use unweighted or weighted covariance matrix. Defaults to \code{TRUE}}
}
\value{
a \code{data.frame} containing standardized mean differences between
   levels of \code{g} for values of \code{x}. The \code{data.frame} contains
   the columns:
   \itemize{
     \item \code{term}: the level being comparing to the reference level
     \item \code{estimate}: SMD estimates
     \item \code{std.error}: (if \code{std.error = TRUE}) SMD standard error estimates
   }
}
\description{
Computes the standardized mean differnce (SMD) between two groups.

\deqn{
 d = \sqrt{D' S^{-1} D}
}

where \eqn{D} is a vector of differences between group 1 and 2 and \eqn{S} is
the covariance matrix of these differences. If \eqn{D} is length 1, the result
is multplied by \eqn{sign(D)}.

In the case of a \code{numeric} or \code{integer} variable, this is equivalent
to:

\deqn{
  d = \frac{\bar{x}_1 - \bar{x}_2}{\sqrt{(s^2_1 + s^2_2)/2}}
}
where \eqn{\bar{x}_g} is the sample mean for group \eqn{g} and \eqn{s^2_g} is
the sample variance.

For a \code{logical} or \code{factor} with only two levels, the equation above is
\eqn{\bar{x}_g = \hat{p}_g}, i.e. the sample proportion and \eqn{s^2_g = \hat{p}_g(1 - \hat{p}_g)}.

When using the SMD to evaluate the effectiveness of weighting in achieving
covariate balance, it is important to isolate the change in SMD before and
after weighting to the change in mean difference, so the denominator (covariance matrix)
must be held constant (Stuart 2008, \doi{doi:10.1002/sim.3207}).
By default, the unweighted covariance matrix is used to compute SMD in both
the unweighted and weighted case. If the weights are not being used to adjust
for covariate imbalance (e.g. case weights), the \code{unwgt.var} argument
can be set to \code{FALSE} to use the weighted covariance matrix as the denominator.
}
\examples{
x <- rnorm(100)
g <- rep(1:2, each = 50)
smd(x, g)
}
