% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_encrypt}
\alias{sm2_encrypt}
\alias{sm2_decrypt}
\title{SM2 Encrypt/Decrypt}
\usage{
sm2_encrypt(data, public_key)

sm2_decrypt(data, private_key)
}
\arguments{
\item{data}{data to be encrypted or decrypted, must be a raw vector}

\item{public_key}{a public key represented as a hexadecimal string}

\item{private_key}{a private key represented as a hexadecimal string}
}
\value{
\describe{
  \item{\link{sm2_encrypt}}{returns a raw vector of the cipher text}
  \item{\link{sm2_decrypt}}{returns a raw vector of the plain text}
}
}
\description{
SM2 is an asymmetric encryption algorithm that can also be used to directly
encrypt data. Typically, A encrypts a file or data using the public key,
passes the ciphertext to B, and B decrypts it using the corresponding private key.
SM2 encryption and decryption are suitable for shorter texts only.
For larger files, the process can be very slow. According to the SM2 algorithm
usage specifications, the encrypted ciphertext needs to be ASN.1 encoded.
We provide the functions sm2_encrypt_asna1 and sm2_decrypt_asna1 for this purpose.
Additionally, some scenarios use different arrangements of c1, c2, c3,
so we also offer the functions sm2_encrypt_c1c2c3 and sm2_decrypt_c1c2c3.
To facilitate the transmission of binary data, we also provide functions
to encrypt data into hexadecimal or base64 strings and decrypt from them.
}
\examples{
## encrypt and decrypt - raw
keypair <- sm2_gen_keypair()
private_key <- keypair$private_key
public_key <- keypair$public_key
data <- 'abc' |> charToRaw()
enc <- sm2_encrypt(data, public_key)
enc
dec <- sm2_decrypt(enc, private_key)
dec
}
