% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logrr.test.R
\name{logrr.test}
\alias{logrr.test}
\title{Global test of clustering using log ratio of spatial 
densities}
\usage{
logrr.test(x)
}
\arguments{
\item{x}{An \code{logrrenv} object from the
\code{\link{logrr}} function.}
}
\value{
A list providing the observed test statistic 
  (\code{islogrr}) and the estimated p-value 
  (\code{pvalue}).
}
\description{
\code{logrr.test} performs a global test of clustering 
for comparing cases and controls using the log ratio of 
spatial densities based on the method of Kelsall and 
Diggle (1995).
}
\examples{
data(grave)
logrrenv = logrr(grave, nsim = 9)
logrr.test(logrrenv)
}
\references{
Waller, L.A. and Gotway, C.A. (2005). Applied
  Spatial Statistics for Public Health Data. Hoboken, NJ:
  Wiley.  
  
  Kelsall, Julia E., and Peter J. Diggle. 
  "Non-parametric estimation of spatial variation in 
  relative risk." Statistics in Medicine 14.21-22 (1995):
  2335-2342.
}
\author{
Joshua French
}
