% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-reduction.R
\name{reduct.theodolite}
\alias{reduct.theodolite}
\title{Data reduction for theodolite measurements using the sun-sight method}
\usage{
reduct.theodolite(loc, az, date, time, tz, az.sun = 0, alt, name, ID, HWT.ID)
}
\arguments{
\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{az}{Array of azimuths. Use \code{\link[astrolibR]{ten}} to convert to
decimal point format if necessary.}

\item{date}{Date of measurements as a string in the format: 'YYYY/MM/DD'}

\item{time}{Time of sun-sight measurement in the format: 'HH:MM:SS'}

\item{tz}{Timezone of input wither as a known acronym (eg. "GMT", "CET") or
a string with continent followed by country capital (eg. "Europe/London").}

\item{az.sun}{(Optional) Measured azimuth of the sun. Defaults to zero.}

\item{alt}{(Optional) Altitude, necessary for automatic declination calculation.
If missing and \emph{loc} is a \emph{skyscapeR.horizon} object then the altitude
will be automatically read from the horizon profile.}

\item{name}{(Optional) Names or labels to identify each measurement.}

\item{ID}{(Optional) IDs or codes to identify each measurement.}

\item{HWT.ID}{(Optional) HeyWhatsThat IDs relating to a previously generated
horizon profile for measurement.}
}
\description{
This function calculates the true azimuth of a structure measured with
a theodolite using the sunsight technique.
}
\examples{
lat <- ten(35,50,37.8)
lon <- ten(14,34,6.4)
az <- c( ten(298,24,10), ten(302,20,40))
az.sun <- ten(327,29,50)
date <- "2016/02/20"
time <- "11:07:17"

data <- reduct.theodolite(c(lat,lon), az, date , time, tz= "Europe/Malta", az.sun)

# Declination will be automatically calculated if the altitude is also given:
data <- reduct.theodolite(c(lat,lon), az, date , time, tz= "Europe/Malta", az.sun, alt=c(2,5))

# Alternatively, the altitude can be automatically retrieved from a horizon profile:
hor <- download.HWT('UFXERSLQ')
data <- reduct.theodolite(hor, az, date, time, tz= "Europe/Malta", az.sun)
}
\references{
Ruggles, C.L.N. (1999). \emph{Astronomy in Prehistoric Britain and Ireland}.
Yale University Press.
}
\seealso{
\code{\link{sunAz}}, \code{\link[astrolibR]{ten}}, \code{\link{sixty}}
}
