% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-reduction.R
\name{reduct.compass}
\alias{reduct.compass}
\title{Data reduction for compass measurements}
\usage{
reduct.compass(loc, mag.az, date, magdec, alt, name, ID, HWT.ID)
}
\arguments{
\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{mag.az}{Array of magnetic azimuth measurements.}

\item{date}{(Optional) Date of measurements as a string in the format: 'YYYY/MM/DD'.
Only necessary is \emph{magdec} is not given.}

\item{magdec}{(Optional) Magnetic declination, if known.}

\item{alt}{(Optional) Altitude, necessary for automatic declination calculation.
If missing and \emph{loc} is a \emph{skyscapeR.horizon} object then the altitude
will be automatically read from the horizon profile.}

\item{name}{(Optional) Names or labels to identify each measurement.}

\item{ID}{(Optional) IDs or codes to identify each measurement.}

\item{HWT.ID}{(Optional) HeyWhatsThat IDs relating to a previously generated
horizon profile for measurement.}
}
\description{
This function calculates the true azimuth of a structure measured with
a compass.
}
\examples{
loc <- c(35,-7)
mag.az <- c(89.5, 105, 109.5)
data <- reduct.compass(loc, mag.az, "2016/04/02")

# Declination will be automatically calculated if the altitude is also given:
data <- reduct.compass(loc, mag.az, "2016/04/02", alt=c(1,2,0))

# Alternatively, the altitude can be automatically retrieved from a horizon profile:
hor <- download.HWT('NML6GMSX')
data <- reduct.compass(hor, mag.az, "2016/04/02")
}
\seealso{
\code{\link{mag.dec}}, \code{\link{az2dec}}, \code{\link{hor2alt}}
}
