% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{skipTrack.diagnostics}
\alias{skipTrack.diagnostics}
\title{skipTrack MCMC Diagnostics}
\usage{
skipTrack.diagnostics(
  stFit,
  param = c("rho", "phi", "Betas", "Gammas", "muis", "tauis", "cijs"),
  method = NULL,
  ...
)
}
\arguments{
\item{stFit}{A list of MCMC results from the skipTrack.fit function.}

\item{param}{A character string specifying the parameter for which diagnostics are to be calculated.
Must be one of: 'rho', 'phi', 'Betas', 'Gammas', 'muis', 'tauis', or 'cijs'.}

\item{method}{An optional parameter specifying the method for calculating diagnostics. See package genMCMCDiag for details. Default is NULL.}

\item{...}{
  Arguments passed on to \code{\link[genMCMCDiag:genDiagnostic]{genMCMCDiag::genDiagnostic}}
  \describe{
    \item{\code{diagnostics}}{A character vector or list of diagnostic functions to be evaluated. Options include 'traceplot', 'ess', 'gelmanRubin', or custom functions. See details.}
    \item{\code{distance}}{Function for evaluating distance between MCMC draws if required by 'method'. This should be a pairwise distance function that operates on elements of the chains from mhDraws. Note that the lanfear and ts methods ALWAYS require a distance function.}
    \item{\code{verbose}}{If TRUE, informative messages are displayed.}
  }}
}
\value{
A mcmcDiag object of MCMC diagnostics for the specified parameter
}
\description{
Takes model results from skipTrack.fit and uses genMCMCDiag to get generalized mcmc diagnostics
}
\details{
If the parameter is 'rho' or 'phi' (the univariate parameters),
the function extracts the specified parameter from the MCMC results and calculates
diagnostics using the genDiagnostic function with the
standard method. If the parameter is any of the other available options, the
function extracts the corresponding values and calculates diagnostics using the genDiagnostic
function with the specified or default method ('lanfear') and hammingDist as the distance function.

Details on the genDiagnostic function can be found in the genMCMCDiag package.
}
\examples{
#Simulated data
simDat <- skipTrack.simulate(n = 100, skipProb = c(.7, .2, .1))

#Run model fit (should typically run with much more than 50 reps)
modFit <- skipTrack.fit(Y = simDat$Y, cluster = simDat$cluster, chains = 2, reps = 50)

#Get diagnostics for cijs
skipTrack.diagnostics(modFit, 'cijs')
}
\seealso{
\code{\link{genDiagnostic}}, \code{\link{skipTrack.fit}}
}
