% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsc.loadScenario.R
\name{fsc.loadScenario}
\alias{fsc.loadScenario}
\title{Load skeleSim scenario parameters for fastsimcoal}
\usage{
fsc.loadScenario(num.pops, pop.size, sample.size, mut.rate, migration = NULL,
  sample.times = NULL, growth.rate = NULL, locus.type = c("dna", "msat",
  "snp"), sequence.length = NULL, num.loci = NULL, transition.rate = NULL,
  gsm.param = NULL, range.constraint = NULL, recomb.rate = NULL,
  chromosome = NULL, num.chrom = NULL, num.gen = NULL,
  source.deme = NULL, sink.deme = NULL, prop.migrants = NULL,
  new.sink.size = NULL, new.sink.growth = NULL, new.mig.mat = NULL,
  fastsimcoal.exec = "fsc252")
}
\arguments{
\item{num.pops}{number of populations.}

\item{pop.size}{a vector giving size of each populaiton.}

\item{sample.size}{a vector giving the number of samples to take from each
population.}

\item{mut.rate}{\code{dna, msat}: per base pair or locus mutation rate.}

\item{migration}{a \code{num.pop} x \code{num.pop} matrix or list of matrices
giving the migration rates between each population.}

\item{sample.times}{a vector giving the number of generations in the past
at which samples are taken.}

\item{growth.rate}{a vector giving the growth rate of each population.}

\item{locus.type}{a character representation of what type of marker to simulate.
Can be "dna", "msat", or "snp".}

\item{sequence.length}{\code{dna}: number of DNA base pairs to use.}

\item{num.loci}{\code{msat, snp}: number of loci to simulate.}

\item{transition.rate}{dna: fraction of substitutions that are transitions.}

\item{gsm.param}{\code{msat}: Value of the geometric parameter for a
Generalized Stepwise Mutation (GSM) model. This value represents the
proportion of mutations that will change the allele size by more than
one step. Values between 0 and 1 are required. A value of 0 is for a
strict Stepwise Mutation Model (SMM).}

\item{range.constraint}{\code{msat}: Range constraint (number of different
alleles allowed). A value of 0 means no range constraint.}

\item{recomb.rate}{recombination rate between adjacent markers.}

\item{chromosome}{number or character identifying which chromosome the marker
is on.}

\item{num.chrom}{a value giving the number of chromosomes that the
\code{locus.params} marker specifications should be copied for. If
\code{NULL}, then chromosome assignment is taken from the
\code{chromosome} column in \code{locus.params}. Any non-\code{NULL}
integer will cause the \code{chromosome} column to be ignored.}

\item{num.gen}{Number of generations, t, before present at which the
historical event happened.}

\item{source.deme}{Source deme (the first listed deme has index 0)}

\item{sink.deme}{Sink deme}

\item{prop.migrants}{Expected proportion of migrants to move from source to sink.}

\item{new.sink.size}{New size for the sink deme, relative to its size at
generation t.}

\item{new.sink.growth}{New growth rate for the sink deme.}

\item{new.mig.mat}{New migration matrix to be used further back in time.}

\item{fastsimcoal.exec}{executable}
}
\value{
a \linkS4class{scenario.params} object to be loaded into a list in the
  \code{scenarios} slot of a \linkS4class{skeleSim.params} object.
}
\description{
Load skeleSim scenario parameters for fastsimcoal
}
\note{
Vectors for \code{pop.size, sample.size, sample.times, and growth.rate}
  will be expanded/recycled to ensure they are as long as \code{num.pops}.

Depending on the choice of \code{locus.type}, values for some arguments may
  be ignored. See argument list above for which arguments are applicable
  to which \code{locus.type}.
}

