% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks.R
\name{countpeaks}
\alias{countpeaks}
\title{Count peaks in a data sequence}
\usage{
countpeaks(x)
}
\arguments{
\item{x}{A double vector.}
}
\value{
An integer value between \code{0} and \code{length(x) - 1}
   representing the number of peaks in the sequence.
}
\description{
This function computes the number of peaks in a double vector, with
peak defined as per \insertCite{Goldfeld65;textual}{skedastic}. The function
is used in the Goldfeld-Quandt nonparametric test for heteroskedasticity in
a linear model. \code{NA} and \code{NaN} values in the sequence are ignored.
}
\examples{
set.seed(9586)
countpeaks(stats::rnorm(20))
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
countpeaks(mtcars_lm$residuals)

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{goldfeld_quandt}}
}
