% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab2df.R
\name{xtab2df}
\alias{xtab2df}
\title{xtab2df}
\usage{
xtab2df(xtab, output = "data.table", threeparttable = FALSE, ...)
}
\arguments{
\item{xtab}{A contingency table, created with `sjPlot::tab_xtab`.}

\item{output}{A character vector. Allowed values are: "data.table" (default),
"data.frame" or "kable". The function's return value is of the respective
type.}

\item{threeparttable}{Boolean value indicating if a
\href{https://www.ctan.org/pkg/threeparttable}{threeparttable} scheme should
be used.}

\item{...}{Further arguments to be passed to `kableExtra::kbl`.}
}
\value{
The table is returned as an R object of the type specified with
  the `output` argument.
}
\description{
Convert table from `sjPlot::tab_xtab` to R data.frame or
  `knitr::kable`
}
\examples{
set.seed(1)
dataset <- data.table::data.table(
  "var1" = sample(
    x = c("yes", "no"),
    size = 100,
    replace = TRUE,
    prob = c(.3, .7)
  ),
  "var2" = sample(
    x = c("yes", "no"),
    size = 100,
    replace = TRUE
  )
)

xtab <- sjPlot::tab_xtab(
  var.row = dataset$var1,
  var.col = dataset$var2,
  show.summary = TRUE,
  use.viewer = FALSE
)

sjtable2df::xtab2df(xtab = xtab)

}
