% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{hoslem_gof}
\alias{hoslem_gof}
\title{Hosmer-Lemeshow Goodness-of-fit-test}
\usage{
hoslem_gof(x, g = 10)
}
\arguments{
\item{x}{Fitted \code{\link{glm}} or \code{\link[lme4]{glmer}} model.}

\item{g}{Number of bins to divide the data. Default is 10.}
}
\value{
An object of class \code{hoslem_test} with
          following values:
          \itemize{
           \item \code{chisq} the Hosmer-Lemeshow chi-squared statistic
           \item \code{df} degrees of freedom
           \item \code{p.value} the p-value for the goodness-of-fit test
          }
}
\description{
This method performs a Hosmer-Lemeshow goodness-of-fit-test
               for generalized linear (mixed) models for binary data.
}
\note{
A well-fitting model shows no significant difference between
        the model and the observed data, i.e. the reported p-value should be
        greater than 0.05.
}
\examples{
data(efc)
# goodness-of-fit test for logistic regression
efc$services <- ifelse(efc$tot_sc_e > 0, 1, 0)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep, data = efc,
           family = binomial(link = "logit"))
hoslem_gof(fit)

}
\seealso{
\code{\link{r2}}
}

