% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_labels.R
\name{get_labels}
\alias{get_labels}
\title{Retrieve value labels of labelled data}
\usage{
get_labels(x, attr.only = FALSE, include.values = NULL,
  include.non.labelled = FALSE, drop.na = TRUE, drop.unused = FALSE)
}
\arguments{
\item{x}{A data frame with variables that have value label attributes (e.g.
from an imported SPSS, SAS or STATA data set, via \code{\link{read_spss}},
\code{\link{read_sas}} or \code{\link{read_stata}}); a variable
(vector) with value label attributes; or a \code{list} of variables
with values label attributes. If \code{x} has no label attributes,
factor levels are returned. See 'Examples'.}

\item{attr.only}{Logical, if \code{TRUE}, labels are only searched for
in the the vector's \code{\link{attributes}}; else, if \code{attr.only = FALSE}
and \code{x} has no label attributes, factor levels or string values
are returned. See 'Examples'.}

\item{include.values}{String, indicating whether the values associated with the
value labels are returned as well. If \code{include.values = "as.name"}
(or \code{include.values = "n"}), values are set as \code{\link{names}}
attribute of the returned object. If \code{include.values = "as.prefix"}
(or \code{include.values = "p"}), values are included as prefix
to each label. See 'Examples'.}

\item{include.non.labelled}{Logical, if \code{TRUE}, values without labels will
also be included in the returned labels (see \code{\link{fill_labels}}).}

\item{drop.na}{Logical, whether labels of tagged NA values (see \code{\link[haven]{tagged_na}})
should be included in the return value or not. By default, labelled
(tagged) missing values are not returned. See \code{\link{get_na}}
for more details on tagged NA values.}

\item{drop.unused}{Logical, if \code{TRUE}, unused labels will be removed from
the return value.}
}
\value{
Either a list with all value labels from all variables if \code{x}
          is a \code{data.frame} or \code{list}; a string with the value
          labels, if \code{x} is a variable;
          or \code{NULL} if no value label attribute was found.
}
\description{
This function returns the value labels of labelled data.
}
\details{
This package can add (and read) value and variable labels either in \CRANpkg{foreign}
           package style (attributes are named \emph{value.labels} and \emph{variable.label})
           or in \CRANpkg{haven} package style (attributes are named \emph{labels} and
           \emph{label}). By default, the \pkg{haven} package style is used.
           \cr \cr
           Working with labelled data is a key feature of the \CRANpkg{sjPlot} package,
           which accesses these attributes to automatically read label attributes
           for labelling axis categories and titles or table rows and columns
           in graphical or tabular outputs.
           \cr \cr
           When working with labelled data, you can, e.g., use
           \code{\link{get_label}} or \code{\link{get_labels}}
           to get a vector of value and variable labels, which can then be
           used with other functions like \code{\link{barplot}} etc.
           See 'Examples'. Furthermore, value and variable labels are used
           when saving data, e.g. to SPSS (see \code{\link{write_spss}}),
           which means that the written SPSS file contains proper labels
           for each variable.
}
\note{
This function is deprecated. Please use \CRANpkg{sjlabelled} for
      labelled data functions now.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav")

# retrieve variable labels
# mydat.var <- get_label(mydat)

# retrieve value labels
# mydat.val <- get_labels(mydat)

data(efc)
get_labels(efc$e42dep)

# simple barplot
barplot(table(efc$e42dep))
# get value labels to annotate barplot
barplot(table(efc$e42dep),
        names.arg = get_labels(efc$e42dep),
        main = get_label(efc$e42dep))

# include associated values
get_labels(efc$e42dep, include.values = "as.name")

# include associated values
get_labels(efc$e42dep, include.values = "as.prefix")

# get labels from multiple variables
get_labels(list(efc$e42dep, efc$e16sex, efc$e15relat))


# create a dummy factor
f1 <- factor(c("hi", "low", "mid"))
# search for label attributes only
get_labels(f1, attr.only = TRUE)
# search for factor levels as well
get_labels(f1)

# same for character vectors
c1 <- c("higher", "lower", "mid")
# search for label attributes only
get_labels(c1, attr.only = TRUE)
# search for string values as well
get_labels(c1)


# create vector
x <- c(1, 2, 3, 2, 4, NA)
# add less labels than values
x <- set_labels(x, labels = c("yes", "maybe", "no"), force.values = FALSE)
# get labels for labelled values only
get_labels(x)
# get labels for all values
get_labels(x, include.non.labelled = TRUE)


# get labels, including tagged NA values
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
x
get_labels(x, include.values = "n", drop.na = FALSE)


# create vector with unused labels
data(efc)
efc$e42dep <- set_labels(
  efc$e42dep,
  labels = c("independent" = 1, "dependent" = 4, "not used" = 5)
)
get_labels(efc$e42dep)
get_labels(efc$e42dep, drop.unused = TRUE)
get_labels(efc$e42dep, include.non.labelled = TRUE, drop.unused = TRUE)

}
