% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frq.R
\name{frq}
\alias{frq}
\title{Summary of labelled vectors}
\usage{
frq(x)
}
\arguments{
\item{x}{A labelled vector.}
}
\value{
A data frame with the summary information of \code{x}.
}
\description{
This function prints a summary, including frequency table,
               of labelled vectors. Unlike \code{\link{summary}}, the
               \code{frq} method also prints label and missing attributes.
}
\examples{
# create labelled factor, with missing flag
x <- labelled(c("M", "M", "F", "X", "N/A"),
              c(Male = "M", Female = "F",
                Refused = "X", "Not applicable" = "N/A"),
              c(FALSE, FALSE, TRUE, TRUE))

frq(x)
}

