% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{read_stata}
\alias{read_stata}
\title{Import STATA dataset as data frame into R}
\usage{
read_stata(path, atomic.to.fac = FALSE)
}
\arguments{
\item{path}{The file path to the STATA data file.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
STATA (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}
}
\value{
A data frame containing the STATA data. Retrieve value labels with \code{\link{get_val_labels}}
  and variable labels with \code{\link{get_var_labels}}.
}
\description{
Imports data from STATA dta-files, including NA's,
               value and variable labels.
}
\note{
This is a wrapper function for \code{\link[haven]{read_dta}} function of the
        \code{haven} package. This function converts the imported data
        into a sjPlot friendly format (see \code{\link{to_sjPlot}}).
}
\seealso{
\code{\link{read_spss}}
}

