% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_case.R
\name{convert_case}
\alias{convert_case}
\title{Generic case conversion for labels}
\usage{
convert_case(lab, case = NULL, verbose = FALSE, ...)
}
\arguments{
\item{lab}{Character vector that should be case converted.}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{\link[snakecase]{to_any_case}} for
more details on this argument.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Further arguments passed down to \code{\link[snakecase]{to_any_case}},
like \code{sep_in} or \code{sep_out}.}
}
\value{
\code{lab}, with converted case.
}
\description{
This function wraps \code{to_any_case()} from the \pkg{snakecase}
  package with certain defaults for the \code{sep_in} and
  \code{sep_out} arguments, used for instance to convert cases in
  \code{\link{get_term_labels}}.
}
\details{
When calling \code{to_any_case()} from \pkg{snakecase}, the
  \code{sep_in} argument is set to \code{"(?<!\\\\d)\\\\."}, and the
  \code{sep_out} to \code{" "}. This gives feasible results from variable
  labels for plot annotations.
}
\examples{
data(iris)
convert_case(colnames(iris))
convert_case(colnames(iris), case = "snake")

}
