% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_labels.R
\name{sits_labels}
\alias{sits_labels}
\alias{sits_labels.sits}
\alias{sits_labels.derived_cube}
\alias{sits_labels.derived_vector_cube}
\alias{sits_labels.raster_cube}
\alias{sits_labels.patterns}
\alias{sits_labels.sits_model}
\alias{sits_labels.default}
\title{Get labels associated to a data set}
\usage{
sits_labels(data)

\method{sits_labels}{sits}(data)

\method{sits_labels}{derived_cube}(data)

\method{sits_labels}{derived_vector_cube}(data)

\method{sits_labels}{raster_cube}(data)

\method{sits_labels}{patterns}(data)

\method{sits_labels}{sits_model}(data)

\method{sits_labels}{default}(data)
}
\arguments{
\item{data}{Time series (tibble of class "sits"),
patterns (tibble of class "patterns"),
data cube (tibble of class "raster_cube"), or
model (closure of class "sits_model").}
}
\value{
The labels of the input data (character vector).
}
\description{
Finds labels in a sits tibble or data cube
}
\examples{
if (sits_run_examples()) {
    # get the labels for a time series set
    labels_ts <- sits_labels(samples_modis_ndvi)
    # get labels for a set of patterns
    labels_pat <- sits_labels(sits_patterns(samples_modis_ndvi))
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # get lables for the model
    labels_mod <- sits_labels(rfor_model)
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # get the labels for a probs cube
    labels_probs <- sits_labels(probs_cube)
}
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
