% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_select.R
\name{sits_select}
\alias{sits_select}
\alias{sits_select.sits}
\alias{sits_select.raster_cube}
\alias{sits_select.patterns}
\alias{sits_select.tbl_df}
\alias{sits_select.default}
\title{Filter bands on a data set (tibble or cube)}
\usage{
sits_select(data, bands = NULL, start_date = NULL, end_date = NULL, ...)

\method{sits_select}{sits}(data, bands = NULL, start_date = NULL, end_date = NULL, ...)

\method{sits_select}{raster_cube}(
  data,
  bands = NULL,
  start_date = NULL,
  end_date = NULL,
  ...,
  dates = NULL,
  tiles = NULL
)

\method{sits_select}{patterns}(data, bands = NULL, start_date = NULL, end_date = NULL, ...)

\method{sits_select}{tbl_df}(data, ...)

\method{sits_select}{default}(data, ...)
}
\arguments{
\item{data}{Tibble with time series or data cube.}

\item{bands}{Character vector with the names of the bands.}

\item{start_date}{Date in YYYY-MM-DD format: start date to be filtered.}

\item{end_date}{Date in YYYY-MM-DD format: end date to be filtered.}

\item{...}{Additional parameters to be provided}

\item{dates}{Character vector with sparse dates to select.}

\item{tiles}{Character vector with the names of the tiles.}
}
\value{
Tibble with time series or data cube.
}
\description{
Filter only the selected bands and dates
                  from a set of time series or froam a data cube.
}
\examples{
# Retrieve a set of time series with 2 classes
data(cerrado_2classes)
# Print the original bands
sits_bands(cerrado_2classes)
# Select only the NDVI band
data <- sits_select(cerrado_2classes, bands = c("NDVI"))
# Print the labels of the resulting tibble
sits_bands(data)
# select start and end date
point_2010 <- sits_select(point_mt_6bands,
              start_date = "2000-01-01",
              end_date = "2030-12-31")

}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
