% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BICadj.R
\name{BICadj}
\alias{BICadj}
\alias{AICadj}
\alias{varexp}
\alias{getL}
\title{Ways to compare SITAR models for fit}
\usage{
BICadj(..., pattern = NULL)

AICadj(..., k = 2, pattern = NULL)

varexp(..., pattern = NULL)

getL(expr)
}
\arguments{
\item{\dots}{one or more SITAR models.}

\item{pattern}{regular expression defining names of models.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is
the classical AIC.}

\item{expr}{quoted or unquoted expression containing a single variable name.}
}
\value{
For \code{BICadj} and \code{AICadj} a named vector of deviances in
increasing order.  For \code{varexp} a named vector of percentages in
decreasing order. For \code{getL} the power the variable in \code{expr}
is raised to, or \code{NA} if \code{expr} is not a power of (a multiple of)
the variable.
}
\description{
\code{BICadj} and \code{AICadj} calculate the BIC and AIC for SITAR models,
adjusting the likelihood for Box-Cox transformed y variables. \code{varexp}
calculates the variance explained by SITAR models, compared to the
corresponding fixed effect models. \code{getL} is used by \code{[AB]ICadj} to
find what power the y variable is raised to.
}
\details{
The deviance is adjusted if the y variable is power-transformed, using the
formula
\deqn{adjusted deviance = deviance - 2n ( (\lambda-1) * log(gm) + %
log(abs(\lambda)) )}{%
deviance - 2n ( (lambda-1) * log(gm) + log(abs(lambda)) )}
where \eqn{\lambda}{lambda} is the power transform, and \eqn{n} and
\eqn{gm} are the length and geometric mean of \code{y}.

The variance explained is given by \deqn{\% explained = 100 * (1 -%
(\sigma_2/\sigma_1)^2)}{\% explained = 100 * (1 - (sigma2/sigma1)^2)} where
\eqn{\sigma_1}{sigma1} is the fixed effects RSD and \eqn{\sigma_2}{sigma2}
the SITAR random effects RSD.

\code{BICadj} and \code{AICadj} accept non-\code{sitar} models with a
\code{logLik} class. \code{varexp} ignores objects not of class
\code{sitar}.

\code{getL} does not detect if the variable in \code{expr}, or its log, contains a multiplying constant,
so that the expressions \code{log(x)} and \code{1 + 2 * log(3 * x)} both return 0.
}
\examples{
data(heights)
## fit sitar model for height
m1 <- sitar(x=age, y=height, id=id, data=heights, df=5)

## update it for log(height)
m2 <- update(m1, y=sqrt(height))

## compare variance explained in the two models
varexp(m1, m2)

## compare BIC adjusting for sqrt transform
## the pattern matches names starting with "m" followed by a digit
BICadj(pattern="^m[0-9]")

## find what power height is raised to
getL(quote(sqrt(sqrt(height))))
}
\seealso{
\code{\link{BIC}}, \code{\link{AIC}}
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{regression}
