% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\encoding{UTF-8}
\name{sirus.fit}
\alias{sirus.fit}
\title{Fit SIRUS.}
\usage{
sirus.fit(data, y, type = "auto", num.rule = 10, p0 = NULL,
  num.rule.max = 25, q = 10, num.trees.step = 1000, alpha = 0.05,
  mtry = NULL, max.depth = 2, num.trees = NULL, num.threads = NULL,
  replace = TRUE, sample.fraction = ifelse(replace, 1, 0.632),
  verbose = TRUE, seed = NULL)
}
\arguments{
\item{data}{Input dataframe, each row is an observation vector.}

\item{y}{Numeric response variable. For classification, y takes only 0 and 1 values.}

\item{type}{'reg' for regression, 'classif' for classification and 'auto' for automatic detection (classification if y takes only 0 and 1 values).}

\item{num.rule}{Number of rules in SIRUS model. Default is 10. Ignored if a p0 value is provided. For regression, the effective number of rules can be smaller than num.rule because of the additional selection in the final linear aggregation of the rules.}

\item{p0}{Selection threshold on the frequency of appearance of a path in the forest. Default is NULL and num.rule is used to select rules.}

\item{num.rule.max}{Maximum number of rules in SIRUS model. Ignored if num.rule is provided.}

\item{q}{Number of quantiles used for node splitting in the forest construction.}

\item{num.trees.step}{Number of trees grown between two evaluations of the stopping criterion. Ignored if num.trees is provided.}

\item{alpha}{Parameter of the stopping criterion for the number of trees: stability has to reach 1 - alpha to stop the growing of the forest. Ignored if num.trees is provided.}

\item{mtry}{Number of variables to possibly split at each node. Default is the number of variables divided by 3.}

\item{max.depth}{Maximal tree depth. Default and strongly recommanded value is 2.}

\item{num.trees}{Number of trees grown in the forest. Default is NULL. If NULL (recommanded), the number of trees is automatically set using a stability based stopping criterion.}

\item{num.threads}{Number of threads used to grow the forest. Default is number of CPUs available.}

\item{replace}{Boolean. If true (default), sample with replacement.}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for sampling with replacement and 0.632 for sampling without replacement.}

\item{verbose}{Boolean. If true, information messages are printed.}

\item{seed}{Random seed. Default is NULL, which generates the seed from R. Set to 0 to ignore the R seed.}
}
\value{
SIRUS model with elements
  \item{\code{rules}}{List of rules in SIRUS model.}
  \item{\code{rules.out}}{List of rule outputs. rule.out: the output mean whether the rule is satisfied or not. supp.size: the number of points inside and outside the rule.}
  \item{\code{proba}}{Frequency of occurence of paths in the forest.}
  \item{\code{paths}}{List of selected paths.}
  \item{\code{mean}}{Mean output over the full training data. Default model output if no rule is selected.}
}
\description{
Fit a SIRUS model for a given number of rules (10 by default) or a given p0.
If the output y takes only 0 and 1 values a classification model is fit, otherwise a regression model is fit.
The number of trees is tuned automatically with a stopping criterion based on stability.
The hyperparameter p0 can be tuned using sirus.cv.
}
\examples{
## load sirus
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## fit sirus
sirus.m <- sirus.fit(data, y)


}
